--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET lock_timeout = 0;
SET client_encoding = 'LATIN1';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = public, pg_catalog;

--
-- Name: generate_poldiv_code_sequence(); Type: FUNCTION; Schema: public; Owner: epd
--

CREATE FUNCTION generate_poldiv_code_sequence() RETURNS SETOF character
    LANGUAGE plpgsql
    AS $$
DECLARE
  a CHAR[] := ARRAY['1','2','3','4','5','6','7','8','9','A','B','C',
                    'D','E','F','G','H','I','J','K','L','M','N','O',
                    'P','Q','R','S','T','U','V','W','X','Y','Z'];
BEGIN
  FOR i IN 1..35 LOOP
    RETURN NEXT a[i];
  END LOOP;

  RETURN;
END;
$$;


ALTER FUNCTION public.generate_poldiv_code_sequence() OWNER TO epd;

--
-- Name: instr(character varying, character varying); Type: FUNCTION; Schema: public; Owner: epd
--

CREATE FUNCTION instr(p_search_in character varying, p_search_for character varying) RETURNS integer
    LANGUAGE plpgsql IMMUTABLE STRICT
    AS $$
DECLARE
  pos INTEGER;
BEGIN
  pos := instr(p_search_in, p_search_for, 1);

  RETURN pos;
END;
$$;


ALTER FUNCTION public.instr(p_search_in character varying, p_search_for character varying) OWNER TO epd;

--
-- Name: instr(character varying, character varying, integer); Type: FUNCTION; Schema: public; Owner: epd
--

CREATE FUNCTION instr(p_search_in character varying, p_search_for character varying, p_beg_index integer) RETURNS integer
    LANGUAGE plpgsql IMMUTABLE STRICT
    AS $$
DECLARE
  pos INTEGER NOT NULL DEFAULT 0;
  temp_str VARCHAR;
  beg INTEGER;
  length INTEGER;
  ss_length INTEGER;
BEGIN
  IF (p_beg_index > 0) THEN
    temp_str := SUBSTRING(p_search_in FROM p_beg_index);
    pos := POSITION(p_search_for IN temp_str);
    IF (pos = 0) THEN
      RETURN 0;
    ELSE
      RETURN pos + p_beg_index - 1;
    END IF;
  ELSE
    ss_length := CHAR_LENGTH(p_search_for);
    length := CHAR_LENGTH(p_search_in);
    beg := length + p_beg_index - ss_length + 2;
    WHILE (beg > 0) LOOP
      temp_str := SUBSTRING(p_search_in FROM beg FOR ss_length);
      pos := POSITION(p_search_for IN temp_str);
      IF (pos > 0) THEN
        RETURN beg;
      END IF;
      beg := beg - 1;
    END LOOP;

    RETURN 0;
  END IF;
END;
$$;


ALTER FUNCTION public.instr(p_search_in character varying, p_search_for character varying, p_beg_index integer) OWNER TO epd;

--
-- Name: instr(character varying, character varying, integer, integer); Type: FUNCTION; Schema: public; Owner: epd
--

CREATE FUNCTION instr(p_search_in character varying, p_search_for character varying, p_beg_index integer, p_occur_index integer) RETURNS integer
    LANGUAGE plpgsql IMMUTABLE STRICT
    AS $$
DECLARE
  pos INTEGER NOT NULL DEFAULT 0;
  occur_number INTEGER NOT NULL DEFAULT 0;
  temp_str VARCHAR;
  beg INTEGER;
  i INTEGER;
  length INTEGER;
  ss_length INTEGER;
BEGIN
  IF (p_beg_index > 0) THEN
    beg := p_beg_index;
    temp_str := SUBSTRING(p_search_in FROM p_beg_index);
    FOR i IN 1..p_occur_index LOOP
      pos := POSITION(p_search_for IN temp_str);
      IF (i = 1) THEN
        beg := beg + pos - 1;
      ELSE
        beg := beg + pos;
      END IF;
      temp_str := SUBSTRING(p_search_in FROM beg + 1);
    END LOOP;

    IF (pos = 0) THEN
      RETURN 0;
    ELSE
      RETURN beg;
    END IF;
  ELSE
    ss_length := CHAR_LENGTH(p_search_for);
    length := CHAR_LENGTH(p_search_in);
    beg := length + p_beg_index - ss_length + 2;
    WHILE (beg > 0) LOOP
      temp_str := SUBSTRING(p_search_in FROM beg FOR ss_length);
      pos := POSITION(p_search_for IN temp_str);
      IF (pos > 0) THEN
        occur_number := occur_number + 1;
        IF (occur_number = p_occur_index) THEN
          RETURN beg;
        END IF;
      END IF;

      beg := beg - 1;
    END LOOP;

    RETURN 0;
  END IF;
END;
$$;


ALTER FUNCTION public.instr(p_search_in character varying, p_search_for character varying, p_beg_index integer, p_occur_index integer) OWNER TO epd;

--
-- Name: restart_sequence(character varying, character varying); Type: FUNCTION; Schema: public; Owner: epd
--

CREATE FUNCTION restart_sequence(p_table character varying, p_column character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
  c1 REFCURSOR;
  sql VARCHAR;
  seq_name VARCHAR;
  start_value INTEGER;

BEGIN
  OPEN c1 FOR EXECUTE 'SELECT COALESCE(MAX(' || quote_ident(p_column) || ') + 1, 1) FROM ' || quote_ident(p_table);
  FETCH c1 INTO start_value;

  seq_name := p_table || '_' || p_column || '_s';

  EXECUTE 'ALTER SEQUENCE ' || seq_name || ' RESTART WITH ' || start_value;

  RETURN;
END;
$$;


ALTER FUNCTION public.restart_sequence(p_table character varying, p_column character varying) OWNER TO epd;

--
-- Name: set_sequence(character varying, character varying); Type: FUNCTION; Schema: public; Owner: epd
--

CREATE FUNCTION set_sequence(p_table character varying, p_column character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE
  s_seq_name VARCHAR;
  s_sql VARCHAR;

BEGIN
  s_seq_name := p_table || '_' || p_column || '_s';

  s_sql := 'SELECT SETVAL(''' || s_seq_name || ''', iv.next_value, false)' ||
           ' FROM (SELECT COALESCE(MAX(' || p_column || ') + 1, 1) AS next_value' ||
                   ' FROM ' || p_table || ') iv';
  EXECUTE s_sql;

  RETURN;
END;
$$;


ALTER FUNCTION public.set_sequence(p_table character varying, p_column character varying) OWNER TO epd;

--
-- Name: to_ascii7(text); Type: FUNCTION; Schema: public; Owner: epd
--

CREATE FUNCTION to_ascii7(p_text text) RETURNS text
    LANGUAGE plpgsql STRICT
    AS $$
DECLARE
  s_results TEXT;

BEGIN
  s_results := TRANSLATE(p_text,
                         '',
                         ' SOZsozYAAAAAAACEEEEIIIITNOOOOOOUUUUYTBaaaaaaaceeeeiiiitnoooooouuuuyty'
                        );

  RETURN s_results;

EXCEPTION
  WHEN OTHERS THEN 
    RETURN NULL;

END
$$;


ALTER FUNCTION public.to_ascii7(p_text text) OWNER TO epd;

--
-- Name: array_accum(anyelement); Type: AGGREGATE; Schema: public; Owner: epd
--

CREATE AGGREGATE array_accum(anyelement) (
    SFUNC = array_append,
    STYPE = anyarray,
    INITCOND = '{}'
);


ALTER AGGREGATE public.array_accum(anyelement) OWNER TO epd;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: aar; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE aar (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    errorlimits double precision,
    taxondated character varying(30),
    labnumber character varying(10),
    notes text
);


ALTER TABLE aar OWNER TO epd;

--
-- Name: agebasis; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE agebasis (
    e_ integer NOT NULL,
    chron_ integer NOT NULL,
    sample_ integer NOT NULL,
    depthcm double precision,
    thickness double precision,
    age double precision,
    ageup double precision,
    agelo double precision,
    rcode character varying(3)
);


ALTER TABLE agebasis OWNER TO epd;

--
-- Name: agebound; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE agebound (
    e_ integer NOT NULL,
    chron_ integer NOT NULL,
    top double precision,
    bottom double precision
);


ALTER TABLE agebound OWNER TO epd;

--
-- Name: alsegs; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE alsegs (
    e_ integer NOT NULL,
    seg_ integer NOT NULL,
    depthtopcm double precision,
    depthbotcm double precision
);


ALTER TABLE alsegs OWNER TO epd;

--
-- Name: authors; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE authors (
    author_ integer NOT NULL,
    publ_ integer NOT NULL,
    orderauthor integer
);


ALTER TABLE authors OWNER TO epd;

--
-- Name: c14; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE c14 (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    agesdup double precision,
    agesdlo double precision,
    grthanage character varying(1),
    basis character varying(1),
    enriched character varying(1),
    labnumber character varying(10),
    deltac13 double precision,
    notes text
);


ALTER TABLE c14 OWNER TO epd;

--
-- Name: chron; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE chron (
    e_ integer NOT NULL,
    chron_ integer NOT NULL,
    defaultchron character varying(1),
    name character varying(40),
    preparedby character varying(30),
    dateprepared character varying(10),
    model character varying(60),
    notes text
);


ALTER TABLE chron OWNER TO epd;

--
-- Name: coredriv; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE coredriv (
    e_ integer NOT NULL,
    drive_ integer NOT NULL,
    drivelabel character varying(10),
    drivetopcm double precision,
    drivebotcm double precision,
    inftopcm double precision,
    infbotcm double precision,
    recoverycm double precision
);


ALTER TABLE coredriv OWNER TO epd;

--
-- Name: descr; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE descr (
    descriptor character varying(4) NOT NULL,
    higherdescr character varying(4),
    description character varying(40)
);


ALTER TABLE descr OWNER TO epd;

--
-- Name: entity; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE entity (
    e_ integer NOT NULL,
    site_ integer,
    sigle character varying(8),
    name character varying(30),
    iscore character varying(1),
    issect character varying(1),
    isssamp character varying(1),
    descriptor character varying(4),
    hasanlam character varying(1),
    entloc character varying(80),
    localveg character varying(240),
    coll_ integer,
    sampdate character varying(10),
    depthatloc double precision,
    icethickcm integer,
    sampdevice character varying(60),
    corediamcm double precision,
    c14depthadj double precision,
    notes text
);


ALTER TABLE entity OWNER TO epd;

--
-- Name: esr; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE esr (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    errorlimits double precision,
    labnumber character varying(10),
    notes text
);


ALTER TABLE esr OWNER TO epd;

--
-- Name: event; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE event (
    event_ integer NOT NULL,
    event character varying(1),
    name character varying(30),
    agebp double precision,
    ageuncertup double precision,
    ageuncertlo double precision,
    publ_ integer
);


ALTER TABLE event OWNER TO epd;

--
-- Name: ft; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE ft (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    errorlimits double precision,
    labnumber character varying(10),
    notes text
);


ALTER TABLE ft OWNER TO epd;

--
-- Name: geochron; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE geochron (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    method character varying(1) NOT NULL,
    depthcm numeric(10,2),
    thickness numeric(10,2),
    materialdated character varying(60),
    publ_ integer
);


ALTER TABLE geochron OWNER TO epd;

--
-- Name: groups; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE groups (
    groupid character varying(4) NOT NULL,
    groupcode character varying(1),
    groupname character varying(60)
);


ALTER TABLE groups OWNER TO epd;

--
-- Name: igcptype; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE igcptype (
    igcptype character varying(8) NOT NULL,
    regionname character varying(80)
);


ALTER TABLE igcptype OWNER TO epd;

--
-- Name: infotype; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE infotype (
    icode character varying(3) NOT NULL,
    infotype character varying(30)
);


ALTER TABLE infotype OWNER TO epd;

--
-- Name: kar; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE kar (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    errorlimits double precision,
    labnumber character varying(10),
    notes text
);


ALTER TABLE kar OWNER TO epd;

--
-- Name: litholgy; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE litholgy (
    e_ integer NOT NULL,
    lith_ integer NOT NULL,
    descript character varying(120),
    depthtopcm double precision,
    depthbotcm double precision,
    loboundary character varying(40)
);


ALTER TABLE litholgy OWNER TO epd;

--
-- Name: loi; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE loi (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    depthcm double precision,
    thickness double precision,
    templo integer,
    loilo double precision,
    temphi integer,
    loihi double precision,
    bulkdens double precision
);


ALTER TABLE loi OWNER TO epd;

--
-- Name: p_agedpt; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_agedpt (
    e_ integer NOT NULL,
    chron_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    ageup double precision,
    agelo double precision,
    deptime double precision
);


ALTER TABLE p_agedpt OWNER TO epd;

--
-- Name: p_anldpt; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_anldpt (
    e_ integer NOT NULL,
    seg_ integer NOT NULL,
    sample_ integer NOT NULL,
    depthcm double precision,
    thickness double precision,
    counttop double precision,
    countbot double precision
);


ALTER TABLE p_anldpt OWNER TO epd;

--
-- Name: p_counts; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_counts (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    var_ integer NOT NULL,
    count double precision
);


ALTER TABLE p_counts OWNER TO epd;

--
-- Name: p_entity; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_entity (
    e_ integer NOT NULL,
    contact_ integer,
    datasource character varying(80),
    dataform character varying(2),
    usestatus character varying(1),
    datacoop character varying(10)
);


ALTER TABLE p_entity OWNER TO epd;

--
-- Name: p_group; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_group (
    set_ integer NOT NULL,
    var_ integer NOT NULL,
    groupid character varying(4)
);


ALTER TABLE p_group OWNER TO epd;

--
-- Name: p_sample; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_sample (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    depthcm numeric(10,2),
    thickness double precision,
    analyst_ integer,
    analydate character varying(10),
    notes text
);


ALTER TABLE p_sample OWNER TO epd;

--
-- Name: p_vars; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_vars (
    var_ integer NOT NULL,
    accvar_ integer NOT NULL,
    syntype character varying(1),
    varcode character varying(8),
    varname character varying(60),
    hvar_ integer,
    mhvar_ integer,
    auth_ integer,
    notes text
);


ALTER TABLE p_vars OWNER TO epd;

--
-- Name: p_vtrans; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE p_vtrans (
    var_ integer NOT NULL,
    translatesto character varying(60)
);


ALTER TABLE p_vtrans OWNER TO epd;

--
-- Name: pb210; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE pb210 (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agead double precision,
    agese double precision,
    grthanage character varying(1),
    notes text
);


ALTER TABLE pb210 OWNER TO epd;

--
-- Name: poldiv1; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE poldiv1 (
    poldiv1 character varying(3) NOT NULL,
    name character varying(45)
);


ALTER TABLE poldiv1 OWNER TO epd;

--
-- Name: poldiv2; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE poldiv2 (
    poldiv1 character varying(3) NOT NULL,
    poldiv2 character varying(2) NOT NULL,
    postcode character varying(2),
    name character varying(45)
);


ALTER TABLE poldiv2 OWNER TO epd;

--
-- Name: poldiv3; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE poldiv3 (
    poldiv1 character varying(3) NOT NULL,
    poldiv2 character varying(2) NOT NULL,
    poldiv3 character varying(3) NOT NULL,
    name character varying(45)
);


ALTER TABLE poldiv3 OWNER TO epd;

--
-- Name: publ; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE publ (
    publ_ integer NOT NULL,
    acc_ integer,
    yearofpubl character varying(4),
    citation text
);


ALTER TABLE publ OWNER TO epd;

--
-- Name: publent; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE publent (
    publ_ integer NOT NULL,
    e_ integer NOT NULL
);


ALTER TABLE publent OWNER TO epd;

--
-- Name: rational; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE rational (
    rcode character varying(3) NOT NULL,
    rationale character varying(60)
);


ALTER TABLE rational OWNER TO epd;

--
-- Name: section; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE section (
    e_ integer NOT NULL,
    section_ integer NOT NULL,
    sectionlabel character varying(60),
    sectiontopcm double precision,
    sectionbotcm double precision
);


ALTER TABLE section OWNER TO epd;

--
-- Name: si32; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE si32 (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    agesdup double precision,
    agesdlo double precision,
    grthanage character varying(1),
    labnumber character varying(10),
    notes text
);


ALTER TABLE si32 OWNER TO epd;

--
-- Name: sitedesc; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE sitedesc (
    site_ integer NOT NULL,
    sitedescript character varying(120),
    physiography character varying(120),
    surroundveg character varying(120),
    vegformation character varying(120),
    igcptype character varying(8)
);


ALTER TABLE sitedesc OWNER TO epd;

--
-- Name: siteinfo; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE siteinfo (
    site_ integer NOT NULL,
    icode character varying(3) NOT NULL,
    publ_ integer NOT NULL
);


ALTER TABLE siteinfo OWNER TO epd;

--
-- Name: siteloc; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE siteloc (
    site_ integer NOT NULL,
    sitename character varying(60),
    sitecode character varying(14),
    siteexists character varying(5),
    poldiv1 character varying(3),
    poldiv2 character varying(2),
    poldiv3 character varying(3),
    latdeg integer,
    latmin integer,
    latsec integer,
    latns character varying(1),
    latdd double precision,
    latdms character varying(9),
    londeg integer,
    lonmin integer,
    lonsec integer,
    lonew character varying(1),
    londd double precision,
    londms character varying(10),
    elevation integer,
    areaofsite double precision
);


ALTER TABLE siteloc OWNER TO epd;

--
-- Name: synevent; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE synevent (
    e_ integer NOT NULL,
    event_ integer NOT NULL,
    depthcm double precision,
    thickness double precision
);


ALTER TABLE synevent OWNER TO epd;

--
-- Name: syntype; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE syntype (
    syntype character varying(1) NOT NULL,
    description character varying(40)
);


ALTER TABLE syntype OWNER TO epd;

--
-- Name: tl; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE tl (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    errorlimits double precision,
    grainsize character varying(10),
    labnumber character varying(10),
    notes text
);


ALTER TABLE tl OWNER TO epd;

--
-- Name: useries; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE useries (
    e_ integer NOT NULL,
    sample_ integer NOT NULL,
    agebp double precision,
    errorlimits double precision,
    labnumber character varying(10),
    notes text
);


ALTER TABLE useries OWNER TO epd;

--
-- Name: workers; Type: TABLE; Schema: public; Owner: epd; Tablespace: 
--

CREATE TABLE workers (
    worker_ integer NOT NULL,
    workeris_ integer NOT NULL,
    status character varying(1),
    lastname character varying(80),
    initials character varying(20),
    firstname character varying(30),
    suffix character varying(10),
    title character varying(30),
    country character varying(3),
    phone character varying(60),
    fax character varying(60),
    emailaddr character varying(60),
    address text
);


ALTER TABLE workers OWNER TO epd;

--
-- Name: aar_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY aar
    ADD CONSTRAINT aar_pkey PRIMARY KEY (e_, sample_);


--
-- Name: agebasis_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY agebasis
    ADD CONSTRAINT agebasis_pkey PRIMARY KEY (e_, chron_, sample_);


--
-- Name: agebound_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY agebound
    ADD CONSTRAINT agebound_pkey PRIMARY KEY (e_, chron_);


--
-- Name: alsegs_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY alsegs
    ADD CONSTRAINT alsegs_pkey PRIMARY KEY (e_, seg_);


--
-- Name: authors_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY authors
    ADD CONSTRAINT authors_pkey PRIMARY KEY (author_, publ_);


--
-- Name: c14_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY c14
    ADD CONSTRAINT c14_pkey PRIMARY KEY (e_, sample_);


--
-- Name: chron_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY chron
    ADD CONSTRAINT chron_pkey PRIMARY KEY (e_, chron_);


--
-- Name: coredriv_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY coredriv
    ADD CONSTRAINT coredriv_pkey PRIMARY KEY (e_, drive_);


--
-- Name: desc_description_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY descr
    ADD CONSTRAINT desc_description_u UNIQUE (description);


--
-- Name: descr_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY descr
    ADD CONSTRAINT descr_pkey PRIMARY KEY (descriptor);


--
-- Name: entity_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY entity
    ADD CONSTRAINT entity_pkey PRIMARY KEY (e_);


--
-- Name: entity_sigle_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY entity
    ADD CONSTRAINT entity_sigle_u UNIQUE (sigle);


--
-- Name: esr_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY esr
    ADD CONSTRAINT esr_pkey PRIMARY KEY (e_, sample_);


--
-- Name: event_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY event
    ADD CONSTRAINT event_pkey PRIMARY KEY (event_);


--
-- Name: ft_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY ft
    ADD CONSTRAINT ft_pkey PRIMARY KEY (e_, sample_);


--
-- Name: geochron_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY geochron
    ADD CONSTRAINT geochron_pkey PRIMARY KEY (e_, sample_);


--
-- Name: groups_groupcode_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_groupcode_u UNIQUE (groupcode);


--
-- Name: groups_groupname_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_groupname_u UNIQUE (groupname);


--
-- Name: groups_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY groups
    ADD CONSTRAINT groups_pkey PRIMARY KEY (groupid);


--
-- Name: igcptype_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY igcptype
    ADD CONSTRAINT igcptype_pkey PRIMARY KEY (igcptype);


--
-- Name: infotype_infotype_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY infotype
    ADD CONSTRAINT infotype_infotype_u UNIQUE (infotype);


--
-- Name: infotype_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY infotype
    ADD CONSTRAINT infotype_pkey PRIMARY KEY (icode);


--
-- Name: kar_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY kar
    ADD CONSTRAINT kar_pkey PRIMARY KEY (e_, sample_);


--
-- Name: litholgy_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY litholgy
    ADD CONSTRAINT litholgy_pkey PRIMARY KEY (e_, lith_);


--
-- Name: loi_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY loi
    ADD CONSTRAINT loi_pkey PRIMARY KEY (e_, sample_);


--
-- Name: p_agedpt_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_agedpt
    ADD CONSTRAINT p_agedpt_pkey PRIMARY KEY (e_, chron_, sample_);


--
-- Name: p_anldpt_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_anldpt
    ADD CONSTRAINT p_anldpt_pkey PRIMARY KEY (e_, seg_, sample_);


--
-- Name: p_counts_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_counts
    ADD CONSTRAINT p_counts_pkey PRIMARY KEY (e_, sample_, var_);


--
-- Name: p_entity_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_entity
    ADD CONSTRAINT p_entity_pkey PRIMARY KEY (e_);


--
-- Name: p_group_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_group
    ADD CONSTRAINT p_group_pkey PRIMARY KEY (set_, var_);


--
-- Name: p_sample_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_sample
    ADD CONSTRAINT p_sample_pkey PRIMARY KEY (e_, sample_);


--
-- Name: p_vars_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_vars
    ADD CONSTRAINT p_vars_pkey PRIMARY KEY (var_);


--
-- Name: p_vars_varcode_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_vars
    ADD CONSTRAINT p_vars_varcode_u UNIQUE (varcode);


--
-- Name: p_vars_varname_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_vars
    ADD CONSTRAINT p_vars_varname_u UNIQUE (varname);


--
-- Name: p_vtrans_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY p_vtrans
    ADD CONSTRAINT p_vtrans_pkey PRIMARY KEY (var_);


--
-- Name: pb210_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY pb210
    ADD CONSTRAINT pb210_pkey PRIMARY KEY (e_, sample_);


--
-- Name: poldiv1_name_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY poldiv1
    ADD CONSTRAINT poldiv1_name_u UNIQUE (name);


--
-- Name: poldiv1_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY poldiv1
    ADD CONSTRAINT poldiv1_pkey PRIMARY KEY (poldiv1);


--
-- Name: poldiv2_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY poldiv2
    ADD CONSTRAINT poldiv2_pkey PRIMARY KEY (poldiv1, poldiv2);


--
-- Name: poldiv3_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY poldiv3
    ADD CONSTRAINT poldiv3_pkey PRIMARY KEY (poldiv1, poldiv2, poldiv3);


--
-- Name: publ_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY publ
    ADD CONSTRAINT publ_pkey PRIMARY KEY (publ_);


--
-- Name: publent_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY publent
    ADD CONSTRAINT publent_pkey PRIMARY KEY (publ_, e_);


--
-- Name: rational_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY rational
    ADD CONSTRAINT rational_pkey PRIMARY KEY (rcode);


--
-- Name: section_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY section
    ADD CONSTRAINT section_pkey PRIMARY KEY (e_, section_);


--
-- Name: si32_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY si32
    ADD CONSTRAINT si32_pkey PRIMARY KEY (e_, sample_);


--
-- Name: sitedesc_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY sitedesc
    ADD CONSTRAINT sitedesc_pkey PRIMARY KEY (site_);


--
-- Name: siteinfo_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY siteinfo
    ADD CONSTRAINT siteinfo_pkey PRIMARY KEY (site_, icode, publ_);


--
-- Name: siteloc_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY siteloc
    ADD CONSTRAINT siteloc_pkey PRIMARY KEY (site_);


--
-- Name: siteloc_sitename_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY siteloc
    ADD CONSTRAINT siteloc_sitename_u UNIQUE (sitename);


--
-- Name: synevent_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY synevent
    ADD CONSTRAINT synevent_pkey PRIMARY KEY (e_, event_);


--
-- Name: syntype_description_u; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY syntype
    ADD CONSTRAINT syntype_description_u UNIQUE (description);


--
-- Name: syntype_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY syntype
    ADD CONSTRAINT syntype_pkey PRIMARY KEY (syntype);


--
-- Name: tl_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY tl
    ADD CONSTRAINT tl_pkey PRIMARY KEY (e_, sample_);


--
-- Name: useries_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY useries
    ADD CONSTRAINT useries_pkey PRIMARY KEY (e_, sample_);


--
-- Name: workers_pkey; Type: CONSTRAINT; Schema: public; Owner: epd; Tablespace: 
--

ALTER TABLE ONLY workers
    ADD CONSTRAINT workers_pkey PRIMARY KEY (worker_);


--
-- Name: aar_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY aar
    ADD CONSTRAINT aar_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: agebasis_e__chron__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY agebasis
    ADD CONSTRAINT agebasis_e__chron__fk FOREIGN KEY (e_, chron_) REFERENCES chron(e_, chron_);


--
-- Name: agebasis_rcode_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY agebasis
    ADD CONSTRAINT agebasis_rcode_fk FOREIGN KEY (rcode) REFERENCES rational(rcode);


--
-- Name: agebound_e__chron__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY agebound
    ADD CONSTRAINT agebound_e__chron__fk FOREIGN KEY (e_, chron_) REFERENCES chron(e_, chron_);


--
-- Name: alsegs_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY alsegs
    ADD CONSTRAINT alsegs_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: authors_author__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY authors
    ADD CONSTRAINT authors_author__fk FOREIGN KEY (author_) REFERENCES workers(worker_);


--
-- Name: authors_publ__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY authors
    ADD CONSTRAINT authors_publ__fk FOREIGN KEY (publ_) REFERENCES publ(publ_);


--
-- Name: c14_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY c14
    ADD CONSTRAINT c14_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: chron_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY chron
    ADD CONSTRAINT chron_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: coredriv_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY coredriv
    ADD CONSTRAINT coredriv_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: entity_coll__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY entity
    ADD CONSTRAINT entity_coll__fk FOREIGN KEY (coll_) REFERENCES workers(worker_);


--
-- Name: entity_descriptor_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY entity
    ADD CONSTRAINT entity_descriptor_fk FOREIGN KEY (descriptor) REFERENCES descr(descriptor);


--
-- Name: entity_site__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY entity
    ADD CONSTRAINT entity_site__fk FOREIGN KEY (site_) REFERENCES siteloc(site_);


--
-- Name: esr_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY esr
    ADD CONSTRAINT esr_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: event_publ__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY event
    ADD CONSTRAINT event_publ__fk FOREIGN KEY (publ_) REFERENCES publ(publ_);


--
-- Name: ft_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY ft
    ADD CONSTRAINT ft_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: geochron_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY geochron
    ADD CONSTRAINT geochron_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: geochron_publ__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY geochron
    ADD CONSTRAINT geochron_publ__fk FOREIGN KEY (publ_) REFERENCES publ(publ_);


--
-- Name: kar_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY kar
    ADD CONSTRAINT kar_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: litholgy_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY litholgy
    ADD CONSTRAINT litholgy_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: loi_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY loi
    ADD CONSTRAINT loi_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: p_agedpt_chron__e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_agedpt
    ADD CONSTRAINT p_agedpt_chron__e__fk FOREIGN KEY (chron_, e_) REFERENCES chron(chron_, e_);


--
-- Name: p_agedpt_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_agedpt
    ADD CONSTRAINT p_agedpt_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES p_sample(e_, sample_);


--
-- Name: p_anldpt_e__seg__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_anldpt
    ADD CONSTRAINT p_anldpt_e__seg__fk FOREIGN KEY (e_, seg_) REFERENCES alsegs(e_, seg_);


--
-- Name: p_counts_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_counts
    ADD CONSTRAINT p_counts_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES p_sample(e_, sample_);


--
-- Name: p_counts_var__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_counts
    ADD CONSTRAINT p_counts_var__fk FOREIGN KEY (var_) REFERENCES p_vars(var_);


--
-- Name: p_entity_contact__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_entity
    ADD CONSTRAINT p_entity_contact__fk FOREIGN KEY (contact_) REFERENCES workers(worker_);


--
-- Name: p_entity_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_entity
    ADD CONSTRAINT p_entity_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: p_group_groupid_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_group
    ADD CONSTRAINT p_group_groupid_fk FOREIGN KEY (groupid) REFERENCES groups(groupid);


--
-- Name: p_group_var__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_group
    ADD CONSTRAINT p_group_var__fk FOREIGN KEY (var_) REFERENCES p_vars(var_);


--
-- Name: p_sample_analyst__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_sample
    ADD CONSTRAINT p_sample_analyst__fk FOREIGN KEY (analyst_) REFERENCES workers(worker_);


--
-- Name: p_sample_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_sample
    ADD CONSTRAINT p_sample_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: p_vars_accvar__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_vars
    ADD CONSTRAINT p_vars_accvar__fk FOREIGN KEY (accvar_) REFERENCES p_vars(var_);


--
-- Name: p_vars_auth__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_vars
    ADD CONSTRAINT p_vars_auth__fk FOREIGN KEY (auth_) REFERENCES publ(publ_);


--
-- Name: p_vars_hvar__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_vars
    ADD CONSTRAINT p_vars_hvar__fk FOREIGN KEY (hvar_) REFERENCES p_vars(var_);


--
-- Name: p_vars_mhvar__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_vars
    ADD CONSTRAINT p_vars_mhvar__fk FOREIGN KEY (mhvar_) REFERENCES p_vars(var_);


--
-- Name: p_vtrans_var__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY p_vtrans
    ADD CONSTRAINT p_vtrans_var__fk FOREIGN KEY (var_) REFERENCES p_vars(var_);


--
-- Name: pb210_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY pb210
    ADD CONSTRAINT pb210_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: poldiv2_poldiv1_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY poldiv2
    ADD CONSTRAINT poldiv2_poldiv1_fk FOREIGN KEY (poldiv1) REFERENCES poldiv1(poldiv1);


--
-- Name: poldiv3_poldiv1_poldiv2_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY poldiv3
    ADD CONSTRAINT poldiv3_poldiv1_poldiv2_fk FOREIGN KEY (poldiv1, poldiv2) REFERENCES poldiv2(poldiv1, poldiv2);


--
-- Name: publent_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY publent
    ADD CONSTRAINT publent_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: publent_publ__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY publent
    ADD CONSTRAINT publent_publ__fk FOREIGN KEY (publ_) REFERENCES publ(publ_);


--
-- Name: section_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY section
    ADD CONSTRAINT section_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: si32_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY si32
    ADD CONSTRAINT si32_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: sitedesc_igcptype_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY sitedesc
    ADD CONSTRAINT sitedesc_igcptype_fk FOREIGN KEY (igcptype) REFERENCES igcptype(igcptype);


--
-- Name: sitedesc_site__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY sitedesc
    ADD CONSTRAINT sitedesc_site__fk FOREIGN KEY (site_) REFERENCES siteloc(site_);


--
-- Name: siteinfo_icode_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY siteinfo
    ADD CONSTRAINT siteinfo_icode_fk FOREIGN KEY (icode) REFERENCES infotype(icode);


--
-- Name: siteinfo_publ__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY siteinfo
    ADD CONSTRAINT siteinfo_publ__fk FOREIGN KEY (publ_) REFERENCES publ(publ_);


--
-- Name: siteinfo_site__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY siteinfo
    ADD CONSTRAINT siteinfo_site__fk FOREIGN KEY (site_) REFERENCES siteloc(site_);


--
-- Name: siteloc_poldiv1_poldiv2_poldiv3_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY siteloc
    ADD CONSTRAINT siteloc_poldiv1_poldiv2_poldiv3_fk FOREIGN KEY (poldiv1, poldiv2, poldiv3) REFERENCES poldiv3(poldiv1, poldiv2, poldiv3);


--
-- Name: synevent_e__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY synevent
    ADD CONSTRAINT synevent_e__fk FOREIGN KEY (e_) REFERENCES entity(e_);


--
-- Name: synevent_event__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY synevent
    ADD CONSTRAINT synevent_event__fk FOREIGN KEY (event_) REFERENCES event(event_);


--
-- Name: tl_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY tl
    ADD CONSTRAINT tl_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: useries_e__sample__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY useries
    ADD CONSTRAINT useries_e__sample__fk FOREIGN KEY (e_, sample_) REFERENCES geochron(e_, sample_);


--
-- Name: workers_country_fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY workers
    ADD CONSTRAINT workers_country_fk FOREIGN KEY (country) REFERENCES poldiv1(poldiv1);


--
-- Name: workers_workeris__fk; Type: FK CONSTRAINT; Schema: public; Owner: epd
--

ALTER TABLE ONLY workers
    ADD CONSTRAINT workers_workeris__fk FOREIGN KEY (workeris_) REFERENCES workers(worker_);


--
-- Name: public; Type: ACL; Schema: -; Owner: postgres
--

REVOKE ALL ON SCHEMA public FROM PUBLIC;
REVOKE ALL ON SCHEMA public FROM postgres;
GRANT ALL ON SCHEMA public TO postgres;
GRANT ALL ON SCHEMA public TO PUBLIC;


--
-- Name: entity; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE entity FROM PUBLIC;
REVOKE ALL ON TABLE entity FROM epd;
GRANT ALL ON TABLE entity TO epd;
GRANT SELECT ON TABLE entity TO wwwadm WITH GRANT OPTION;


--
-- Name: groups; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE groups FROM PUBLIC;
REVOKE ALL ON TABLE groups FROM epd;
GRANT ALL ON TABLE groups TO epd;
GRANT SELECT ON TABLE groups TO wwwadm;


--
-- Name: p_counts; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE p_counts FROM PUBLIC;
REVOKE ALL ON TABLE p_counts FROM epd;
GRANT ALL ON TABLE p_counts TO epd;
GRANT SELECT ON TABLE p_counts TO wwwadm;


--
-- Name: p_entity; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE p_entity FROM PUBLIC;
REVOKE ALL ON TABLE p_entity FROM epd;
GRANT ALL ON TABLE p_entity TO epd;
GRANT SELECT ON TABLE p_entity TO wwwadm;


--
-- Name: p_group; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE p_group FROM PUBLIC;
REVOKE ALL ON TABLE p_group FROM epd;
GRANT ALL ON TABLE p_group TO epd;
GRANT SELECT ON TABLE p_group TO wwwadm;


--
-- Name: p_sample; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE p_sample FROM PUBLIC;
REVOKE ALL ON TABLE p_sample FROM epd;
GRANT ALL ON TABLE p_sample TO epd;
GRANT SELECT ON TABLE p_sample TO wwwadm;


--
-- Name: p_vars; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE p_vars FROM PUBLIC;
REVOKE ALL ON TABLE p_vars FROM epd;
GRANT ALL ON TABLE p_vars TO epd;
GRANT SELECT ON TABLE p_vars TO wwwadm;


--
-- Name: poldiv1; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE poldiv1 FROM PUBLIC;
REVOKE ALL ON TABLE poldiv1 FROM epd;
GRANT ALL ON TABLE poldiv1 TO epd;
GRANT SELECT ON TABLE poldiv1 TO wwwadm;


--
-- Name: siteloc; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE siteloc FROM PUBLIC;
REVOKE ALL ON TABLE siteloc FROM epd;
GRANT ALL ON TABLE siteloc TO epd;
GRANT SELECT ON TABLE siteloc TO wwwadm WITH GRANT OPTION;


--
-- Name: workers; Type: ACL; Schema: public; Owner: epd
--

REVOKE ALL ON TABLE workers FROM PUBLIC;
REVOKE ALL ON TABLE workers FROM epd;
GRANT ALL ON TABLE workers TO epd;
GRANT SELECT ON TABLE workers TO wwwadm;


--
-- PostgreSQL database dump complete
--

